/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.greengrass.model.ListOfVersionInformationCopier;
import software.amazon.awssdk.services.greengrass.model.VersionInformation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCoreDefinitionVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListCoreDefinitionVersionsResponse> {
    private final String nextToken;
    private final List<VersionInformation> versions;

    private ListCoreDefinitionVersionsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.versions = builder.versions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VersionInformation> versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.versions() == null ? 0 : this.versions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoreDefinitionVersionsResponse)) {
            return false;
        }
        ListCoreDefinitionVersionsResponse other = (ListCoreDefinitionVersionsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.versions() == null ^ this.versions() == null) {
            return false;
        }
        return other.versions() == null || other.versions().equals(this.versions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.versions() != null) {
            sb.append("Versions: ").append(this.versions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VersionInformation> versions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoreDefinitionVersionsResponse model) {
            this.setNextToken(model.nextToken);
            this.setVersions(model.versions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VersionInformation> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<VersionInformation> versions) {
            this.versions = ListOfVersionInformationCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(VersionInformation ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<VersionInformation> versions) {
            this.versions = ListOfVersionInformationCopier.copy(versions);
        }

        public ListCoreDefinitionVersionsResponse build() {
            return new ListCoreDefinitionVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCoreDefinitionVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder versions(Collection<VersionInformation> var1);

        public Builder versions(VersionInformation ... var1);
    }
}

