/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.transform.ConnectivityInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConnectivityInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, ConnectivityInfo> {
    private final String hostAddress;
    private final String id;
    private final String metadata;
    private final Integer portNumber;

    private ConnectivityInfo(BuilderImpl builder) {
        this.hostAddress = builder.hostAddress;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.portNumber = builder.portNumber;
    }

    public String hostAddress() {
        return this.hostAddress;
    }

    public String id() {
        return this.id;
    }

    public String metadata() {
        return this.metadata;
    }

    public Integer portNumber() {
        return this.portNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostAddress() == null ? 0 : this.hostAddress().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.metadata() == null ? 0 : this.metadata().hashCode());
        hashCode = 31 * hashCode + (this.portNumber() == null ? 0 : this.portNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectivityInfo)) {
            return false;
        }
        ConnectivityInfo other = (ConnectivityInfo)obj;
        if (other.hostAddress() == null ^ this.hostAddress() == null) {
            return false;
        }
        if (other.hostAddress() != null && !other.hostAddress().equals(this.hostAddress())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.metadata() == null ^ this.metadata() == null) {
            return false;
        }
        if (other.metadata() != null && !other.metadata().equals(this.metadata())) {
            return false;
        }
        if (other.portNumber() == null ^ this.portNumber() == null) {
            return false;
        }
        return other.portNumber() == null || other.portNumber().equals(this.portNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostAddress() != null) {
            sb.append("HostAddress: ").append(this.hostAddress()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.metadata() != null) {
            sb.append("Metadata: ").append(this.metadata()).append(",");
        }
        if (this.portNumber() != null) {
            sb.append("PortNumber: ").append(this.portNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectivityInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String hostAddress;
        private String id;
        private String metadata;
        private Integer portNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectivityInfo model) {
            this.setHostAddress(model.hostAddress);
            this.setId(model.id);
            this.setMetadata(model.metadata);
            this.setPortNumber(model.portNumber);
        }

        public final String getHostAddress() {
            return this.hostAddress;
        }

        @Override
        public final Builder hostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public final void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final Integer getPortNumber() {
            return this.portNumber;
        }

        @Override
        public final Builder portNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public final void setPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
        }

        public ConnectivityInfo build() {
            return new ConnectivityInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConnectivityInfo> {
        public Builder hostAddress(String var1);

        public Builder id(String var1);

        public Builder metadata(String var1);

        public Builder portNumber(Integer var1);
    }
}

