/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.ConnectivityInfo;
import software.amazon.awssdk.services.greengrass.model.ListOfConnectivityInfoCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateConnectivityInfoRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
    private final List<ConnectivityInfo> connectivityInfo;
    private final String thingName;

    private UpdateConnectivityInfoRequest(BuilderImpl builder) {
        this.connectivityInfo = builder.connectivityInfo;
        this.thingName = builder.thingName;
    }

    public List<ConnectivityInfo> connectivityInfo() {
        return this.connectivityInfo;
    }

    public String thingName() {
        return this.thingName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.connectivityInfo() == null ? 0 : this.connectivityInfo().hashCode());
        hashCode = 31 * hashCode + (this.thingName() == null ? 0 : this.thingName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectivityInfoRequest)) {
            return false;
        }
        UpdateConnectivityInfoRequest other = (UpdateConnectivityInfoRequest)((Object)obj);
        if (other.connectivityInfo() == null ^ this.connectivityInfo() == null) {
            return false;
        }
        if (other.connectivityInfo() != null && !other.connectivityInfo().equals(this.connectivityInfo())) {
            return false;
        }
        if (other.thingName() == null ^ this.thingName() == null) {
            return false;
        }
        return other.thingName() == null || other.thingName().equals(this.thingName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.connectivityInfo() != null) {
            sb.append("ConnectivityInfo: ").append(this.connectivityInfo()).append(",");
        }
        if (this.thingName() != null) {
            sb.append("ThingName: ").append(this.thingName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ConnectivityInfo> connectivityInfo;
        private String thingName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectivityInfoRequest model) {
            this.setConnectivityInfo(model.connectivityInfo);
            this.setThingName(model.thingName);
        }

        public final Collection<ConnectivityInfo> getConnectivityInfo() {
            return this.connectivityInfo;
        }

        @Override
        public final Builder connectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = ListOfConnectivityInfoCopier.copy(connectivityInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectivityInfo(ConnectivityInfo ... connectivityInfo) {
            this.connectivityInfo(Arrays.asList(connectivityInfo));
            return this;
        }

        public final void setConnectivityInfo(Collection<ConnectivityInfo> connectivityInfo) {
            this.connectivityInfo = ListOfConnectivityInfoCopier.copy(connectivityInfo);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public UpdateConnectivityInfoRequest build() {
            return new UpdateConnectivityInfoRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateConnectivityInfoRequest> {
        public Builder connectivityInfo(Collection<ConnectivityInfo> var1);

        public Builder connectivityInfo(ConnectivityInfo ... var1);

        public Builder thingName(String var1);
    }
}

