/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.S3MachineLearningModelResourceData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class S3MachineLearningModelResourceDataMarshaller {
    private static final MarshallingInfo<String> DESTINATIONPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationPath").isBinary(false).build();
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").isBinary(false).build();
    private static final S3MachineLearningModelResourceDataMarshaller INSTANCE = new S3MachineLearningModelResourceDataMarshaller();

    private S3MachineLearningModelResourceDataMarshaller() {
    }

    public static S3MachineLearningModelResourceDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3MachineLearningModelResourceData s3MachineLearningModelResourceData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)s3MachineLearningModelResourceData, (String)"s3MachineLearningModelResourceData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)s3MachineLearningModelResourceData.destinationPath(), DESTINATIONPATH_BINDING);
            protocolMarshaller.marshall((Object)s3MachineLearningModelResourceData.s3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

