/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Resource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESOURCEDATACONTAINER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceDataContainer").isBinary(false).build();
    private static final ResourceMarshaller INSTANCE = new ResourceMarshaller();

    private ResourceMarshaller() {
    }

    public static ResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resource, (String)"resource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resource.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)resource.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resource.resourceDataContainer(), RESOURCEDATACONTAINER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

