/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.ResourceDefinitionVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceDefinitionVersionMarshaller {
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Resources").isBinary(false).build();
    private static final ResourceDefinitionVersionMarshaller INSTANCE = new ResourceDefinitionVersionMarshaller();

    private ResourceDefinitionVersionMarshaller() {
    }

    public static ResourceDefinitionVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceDefinitionVersion resourceDefinitionVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceDefinitionVersion, (String)"resourceDefinitionVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(resourceDefinitionVersion.resources(), RESOURCES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

