/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.greengrass.model.ResourceDataContainer;
import software.amazon.awssdk.services.greengrass.transform.LocalDeviceResourceDataUnmarshaller;
import software.amazon.awssdk.services.greengrass.transform.LocalVolumeResourceDataUnmarshaller;
import software.amazon.awssdk.services.greengrass.transform.S3MachineLearningModelResourceDataUnmarshaller;
import software.amazon.awssdk.services.greengrass.transform.SageMakerMachineLearningModelResourceDataUnmarshaller;

public class ResourceDataContainerUnmarshaller
implements Unmarshaller<ResourceDataContainer, JsonUnmarshallerContext> {
    private static final ResourceDataContainerUnmarshaller INSTANCE = new ResourceDataContainerUnmarshaller();

    public ResourceDataContainer unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceDataContainer.Builder resourceDataContainerBuilder = ResourceDataContainer.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("LocalDeviceResourceData", targetDepth)) {
                    context.nextToken();
                    resourceDataContainerBuilder.localDeviceResourceData(LocalDeviceResourceDataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LocalVolumeResourceData", targetDepth)) {
                    context.nextToken();
                    resourceDataContainerBuilder.localVolumeResourceData(LocalVolumeResourceDataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("S3MachineLearningModelResourceData", targetDepth)) {
                    context.nextToken();
                    resourceDataContainerBuilder.s3MachineLearningModelResourceData(S3MachineLearningModelResourceDataUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SageMakerMachineLearningModelResourceData", targetDepth)) {
                    context.nextToken();
                    resourceDataContainerBuilder.sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceDataUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceDataContainer)resourceDataContainerBuilder.build();
    }

    public static ResourceDataContainerUnmarshaller getInstance() {
        return INSTANCE;
    }
}

