/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.ResourceDataContainer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceDataContainerMarshaller {
    private static final MarshallingInfo<StructuredPojo> LOCALDEVICERESOURCEDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalDeviceResourceData").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOCALVOLUMERESOURCEDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalVolumeResourceData").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3MACHINELEARNINGMODELRESOURCEDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3MachineLearningModelResourceData").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SAGEMAKERMACHINELEARNINGMODELRESOURCEDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SageMakerMachineLearningModelResourceData").isBinary(false).build();
    private static final ResourceDataContainerMarshaller INSTANCE = new ResourceDataContainerMarshaller();

    private ResourceDataContainerMarshaller() {
    }

    public static ResourceDataContainerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceDataContainer resourceDataContainer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceDataContainer, (String)"resourceDataContainer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceDataContainer.localDeviceResourceData(), LOCALDEVICERESOURCEDATA_BINDING);
            protocolMarshaller.marshall((Object)resourceDataContainer.localVolumeResourceData(), LOCALVOLUMERESOURCEDATA_BINDING);
            protocolMarshaller.marshall((Object)resourceDataContainer.s3MachineLearningModelResourceData(), S3MACHINELEARNINGMODELRESOURCEDATA_BINDING);
            protocolMarshaller.marshall((Object)resourceDataContainer.sageMakerMachineLearningModelResourceData(), SAGEMAKERMACHINELEARNINGMODELRESOURCEDATA_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

