/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.LoggerDefinitionVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LoggerDefinitionVersionMarshaller {
    private static final MarshallingInfo<List> LOGGERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Loggers").isBinary(false).build();
    private static final LoggerDefinitionVersionMarshaller INSTANCE = new LoggerDefinitionVersionMarshaller();

    private LoggerDefinitionVersionMarshaller() {
    }

    public static LoggerDefinitionVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LoggerDefinitionVersion loggerDefinitionVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)loggerDefinitionVersion, (String)"loggerDefinitionVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(loggerDefinitionVersion.loggers(), LOGGERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

