/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.LocalVolumeResourceData;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LocalVolumeResourceDataMarshaller {
    private static final MarshallingInfo<String> DESTINATIONPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationPath").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> GROUPOWNERSETTING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupOwnerSetting").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourcePath").isBinary(false).build();
    private static final LocalVolumeResourceDataMarshaller INSTANCE = new LocalVolumeResourceDataMarshaller();

    private LocalVolumeResourceDataMarshaller() {
    }

    public static LocalVolumeResourceDataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LocalVolumeResourceData localVolumeResourceData, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)localVolumeResourceData, (String)"localVolumeResourceData");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)localVolumeResourceData.destinationPath(), DESTINATIONPATH_BINDING);
            protocolMarshaller.marshall((Object)localVolumeResourceData.groupOwnerSetting(), GROUPOWNERSETTING_BINDING);
            protocolMarshaller.marshall((Object)localVolumeResourceData.sourcePath(), SOURCEPATH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

