/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.greengrass.model.GroupVersion;

public class GroupVersionUnmarshaller
implements Unmarshaller<GroupVersion, JsonUnmarshallerContext> {
    private static final GroupVersionUnmarshaller INSTANCE = new GroupVersionUnmarshaller();

    public GroupVersion unmarshall(JsonUnmarshallerContext context) throws Exception {
        GroupVersion.Builder groupVersionBuilder = GroupVersion.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("CoreDefinitionVersionArn", targetDepth)) {
                    context.nextToken();
                    groupVersionBuilder.coreDefinitionVersionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DeviceDefinitionVersionArn", targetDepth)) {
                    context.nextToken();
                    groupVersionBuilder.deviceDefinitionVersionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FunctionDefinitionVersionArn", targetDepth)) {
                    context.nextToken();
                    groupVersionBuilder.functionDefinitionVersionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LoggerDefinitionVersionArn", targetDepth)) {
                    context.nextToken();
                    groupVersionBuilder.loggerDefinitionVersionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceDefinitionVersionArn", targetDepth)) {
                    context.nextToken();
                    groupVersionBuilder.resourceDefinitionVersionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SubscriptionDefinitionVersionArn", targetDepth)) {
                    context.nextToken();
                    groupVersionBuilder.subscriptionDefinitionVersionArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GroupVersion)groupVersionBuilder.build();
    }

    public static GroupVersionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

