/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.FunctionConfigurationEnvironment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FunctionConfigurationEnvironmentMarshaller {
    private static final MarshallingInfo<Boolean> ACCESSSYSFS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessSysfs").isBinary(false).build();
    private static final MarshallingInfo<List> RESOURCEACCESSPOLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceAccessPolicies").isBinary(false).build();
    private static final MarshallingInfo<Map> VARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Variables").isBinary(false).build();
    private static final FunctionConfigurationEnvironmentMarshaller INSTANCE = new FunctionConfigurationEnvironmentMarshaller();

    private FunctionConfigurationEnvironmentMarshaller() {
    }

    public static FunctionConfigurationEnvironmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionConfigurationEnvironment functionConfigurationEnvironment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)functionConfigurationEnvironment, (String)"functionConfigurationEnvironment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)functionConfigurationEnvironment.accessSysfs(), ACCESSSYSFS_BINDING);
            protocolMarshaller.marshall(functionConfigurationEnvironment.resourceAccessPolicies(), RESOURCEACCESSPOLICIES_BINDING);
            protocolMarshaller.marshall(functionConfigurationEnvironment.variables(), VARIABLES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

