/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateSoftwareUpdateJobRequestModelMarshaller {
    private static final MarshallingInfo<String> AMZNCLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").isBinary(false).build();
    private static final MarshallingInfo<String> S3URLSIGNERROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3UrlSignerRole").isBinary(false).build();
    private static final MarshallingInfo<String> SOFTWARETOUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SoftwareToUpdate").isBinary(false).build();
    private static final MarshallingInfo<String> UPDATEAGENTLOGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateAgentLogLevel").isBinary(false).build();
    private static final MarshallingInfo<List> UPDATETARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateTargets").isBinary(false).build();
    private static final MarshallingInfo<String> UPDATETARGETSARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateTargetsArchitecture").isBinary(false).build();
    private static final MarshallingInfo<String> UPDATETARGETSOPERATINGSYSTEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateTargetsOperatingSystem").isBinary(false).build();
    private static final CreateSoftwareUpdateJobRequestModelMarshaller INSTANCE = new CreateSoftwareUpdateJobRequestModelMarshaller();

    private CreateSoftwareUpdateJobRequestModelMarshaller() {
    }

    public static CreateSoftwareUpdateJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateSoftwareUpdateJobRequest createSoftwareUpdateJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createSoftwareUpdateJobRequest), (String)"createSoftwareUpdateJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createSoftwareUpdateJobRequest.amznClientToken(), AMZNCLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createSoftwareUpdateJobRequest.s3UrlSignerRole(), S3URLSIGNERROLE_BINDING);
            protocolMarshaller.marshall((Object)createSoftwareUpdateJobRequest.softwareToUpdateAsString(), SOFTWARETOUPDATE_BINDING);
            protocolMarshaller.marshall((Object)createSoftwareUpdateJobRequest.updateAgentLogLevelAsString(), UPDATEAGENTLOGLEVEL_BINDING);
            protocolMarshaller.marshall(createSoftwareUpdateJobRequest.updateTargets(), UPDATETARGETS_BINDING);
            protocolMarshaller.marshall((Object)createSoftwareUpdateJobRequest.updateTargetsArchitectureAsString(), UPDATETARGETSARCHITECTURE_BINDING);
            protocolMarshaller.marshall((Object)createSoftwareUpdateJobRequest.updateTargetsOperatingSystemAsString(), UPDATETARGETSOPERATINGSYSTEM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

