/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateGroupVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> AMZNCLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").isBinary(false).build();
    private static final MarshallingInfo<String> COREDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> GROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("GroupId").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGERDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggerDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> SUBSCRIPTIONDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionDefinitionVersionArn").isBinary(false).build();
    private static final CreateGroupVersionRequestModelMarshaller INSTANCE = new CreateGroupVersionRequestModelMarshaller();

    private CreateGroupVersionRequestModelMarshaller() {
    }

    public static CreateGroupVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateGroupVersionRequest createGroupVersionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createGroupVersionRequest), (String)"createGroupVersionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createGroupVersionRequest.amznClientToken(), AMZNCLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createGroupVersionRequest.coreDefinitionVersionArn(), COREDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)createGroupVersionRequest.deviceDefinitionVersionArn(), DEVICEDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)createGroupVersionRequest.functionDefinitionVersionArn(), FUNCTIONDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)createGroupVersionRequest.groupId(), GROUPID_BINDING);
            protocolMarshaller.marshall((Object)createGroupVersionRequest.loggerDefinitionVersionArn(), LOGGERDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)createGroupVersionRequest.resourceDefinitionVersionArn(), RESOURCEDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)createGroupVersionRequest.subscriptionDefinitionVersionArn(), SUBSCRIPTIONDEFINITIONVERSIONARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

