/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateCoreDefinitionVersionRequestModelMarshaller {
    private static final MarshallingInfo<String> AMZNCLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amzn-Client-Token").isBinary(false).build();
    private static final MarshallingInfo<String> COREDEFINITIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("CoreDefinitionId").isBinary(false).build();
    private static final MarshallingInfo<List> CORES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cores").isBinary(false).build();
    private static final CreateCoreDefinitionVersionRequestModelMarshaller INSTANCE = new CreateCoreDefinitionVersionRequestModelMarshaller();

    private CreateCoreDefinitionVersionRequestModelMarshaller() {
    }

    public static CreateCoreDefinitionVersionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateCoreDefinitionVersionRequest createCoreDefinitionVersionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createCoreDefinitionVersionRequest), (String)"createCoreDefinitionVersionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createCoreDefinitionVersionRequest.amznClientToken(), AMZNCLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createCoreDefinitionVersionRequest.coreDefinitionId(), COREDEFINITIONID_BINDING);
            protocolMarshaller.marshall(createCoreDefinitionVersionRequest.cores(), CORES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

