/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.Core;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CoreMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CertificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SYNCSHADOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncShadow").isBinary(false).build();
    private static final MarshallingInfo<String> THINGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThingArn").isBinary(false).build();
    private static final CoreMarshaller INSTANCE = new CoreMarshaller();

    private CoreMarshaller() {
    }

    public static CoreMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Core core, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)core, (String)"core");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)core.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)core.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)core.syncShadow(), SYNCSHADOW_BINDING);
            protocolMarshaller.marshall((Object)core.thingArn(), THINGARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

