/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.transform.SageMakerMachineLearningModelResourceDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SageMakerMachineLearningModelResourceData
implements StructuredPojo,
ToCopyableBuilder<Builder, SageMakerMachineLearningModelResourceData> {
    private final String destinationPath;
    private final String sageMakerJobArn;

    private SageMakerMachineLearningModelResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.sageMakerJobArn = builder.sageMakerJobArn;
    }

    public String destinationPath() {
        return this.destinationPath;
    }

    public String sageMakerJobArn() {
        return this.sageMakerJobArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerJobArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerMachineLearningModelResourceData)) {
            return false;
        }
        SageMakerMachineLearningModelResourceData other = (SageMakerMachineLearningModelResourceData)obj;
        return Objects.equals(this.destinationPath(), other.destinationPath()) && Objects.equals(this.sageMakerJobArn(), other.sageMakerJobArn());
    }

    public String toString() {
        return ToString.builder((String)"SageMakerMachineLearningModelResourceData").add("DestinationPath", (Object)this.destinationPath()).add("SageMakerJobArn", (Object)this.sageMakerJobArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
            case "SageMakerJobArn": {
                return Optional.ofNullable(clazz.cast(this.sageMakerJobArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SageMakerMachineLearningModelResourceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationPath;
        private String sageMakerJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerMachineLearningModelResourceData model) {
            this.destinationPath(model.destinationPath);
            this.sageMakerJobArn(model.sageMakerJobArn);
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final String getSageMakerJobArn() {
            return this.sageMakerJobArn;
        }

        @Override
        public final Builder sageMakerJobArn(String sageMakerJobArn) {
            this.sageMakerJobArn = sageMakerJobArn;
            return this;
        }

        public final void setSageMakerJobArn(String sageMakerJobArn) {
            this.sageMakerJobArn = sageMakerJobArn;
        }

        public SageMakerMachineLearningModelResourceData build() {
            return new SageMakerMachineLearningModelResourceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SageMakerMachineLearningModelResourceData> {
        public Builder destinationPath(String var1);

        public Builder sageMakerJobArn(String var1);
    }
}

