/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.transform.S3MachineLearningModelResourceDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3MachineLearningModelResourceData
implements StructuredPojo,
ToCopyableBuilder<Builder, S3MachineLearningModelResourceData> {
    private final String destinationPath;
    private final String s3Uri;

    private S3MachineLearningModelResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.s3Uri = builder.s3Uri;
    }

    public String destinationPath() {
        return this.destinationPath;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3MachineLearningModelResourceData)) {
            return false;
        }
        S3MachineLearningModelResourceData other = (S3MachineLearningModelResourceData)obj;
        return Objects.equals(this.destinationPath(), other.destinationPath()) && Objects.equals(this.s3Uri(), other.s3Uri());
    }

    public String toString() {
        return ToString.builder((String)"S3MachineLearningModelResourceData").add("DestinationPath", (Object)this.destinationPath()).add("S3Uri", (Object)this.s3Uri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3MachineLearningModelResourceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationPath;
        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(S3MachineLearningModelResourceData model) {
            this.destinationPath(model.destinationPath);
            this.s3Uri(model.s3Uri);
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public S3MachineLearningModelResourceData build() {
            return new S3MachineLearningModelResourceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3MachineLearningModelResourceData> {
        public Builder destinationPath(String var1);

        public Builder s3Uri(String var1);
    }
}

