/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.LocalDeviceResourceData;
import software.amazon.awssdk.services.greengrass.model.LocalVolumeResourceData;
import software.amazon.awssdk.services.greengrass.model.S3MachineLearningModelResourceData;
import software.amazon.awssdk.services.greengrass.model.SageMakerMachineLearningModelResourceData;
import software.amazon.awssdk.services.greengrass.transform.ResourceDataContainerMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceDataContainer
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceDataContainer> {
    private final LocalDeviceResourceData localDeviceResourceData;
    private final LocalVolumeResourceData localVolumeResourceData;
    private final S3MachineLearningModelResourceData s3MachineLearningModelResourceData;
    private final SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData;

    private ResourceDataContainer(BuilderImpl builder) {
        this.localDeviceResourceData = builder.localDeviceResourceData;
        this.localVolumeResourceData = builder.localVolumeResourceData;
        this.s3MachineLearningModelResourceData = builder.s3MachineLearningModelResourceData;
        this.sageMakerMachineLearningModelResourceData = builder.sageMakerMachineLearningModelResourceData;
    }

    public LocalDeviceResourceData localDeviceResourceData() {
        return this.localDeviceResourceData;
    }

    public LocalVolumeResourceData localVolumeResourceData() {
        return this.localVolumeResourceData;
    }

    public S3MachineLearningModelResourceData s3MachineLearningModelResourceData() {
        return this.s3MachineLearningModelResourceData;
    }

    public SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData() {
        return this.sageMakerMachineLearningModelResourceData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localDeviceResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.localVolumeResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3MachineLearningModelResourceData());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerMachineLearningModelResourceData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataContainer)) {
            return false;
        }
        ResourceDataContainer other = (ResourceDataContainer)obj;
        return Objects.equals(this.localDeviceResourceData(), other.localDeviceResourceData()) && Objects.equals(this.localVolumeResourceData(), other.localVolumeResourceData()) && Objects.equals(this.s3MachineLearningModelResourceData(), other.s3MachineLearningModelResourceData()) && Objects.equals(this.sageMakerMachineLearningModelResourceData(), other.sageMakerMachineLearningModelResourceData());
    }

    public String toString() {
        return ToString.builder((String)"ResourceDataContainer").add("LocalDeviceResourceData", (Object)this.localDeviceResourceData()).add("LocalVolumeResourceData", (Object)this.localVolumeResourceData()).add("S3MachineLearningModelResourceData", (Object)this.s3MachineLearningModelResourceData()).add("SageMakerMachineLearningModelResourceData", (Object)this.sageMakerMachineLearningModelResourceData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalDeviceResourceData": {
                return Optional.ofNullable(clazz.cast(this.localDeviceResourceData()));
            }
            case "LocalVolumeResourceData": {
                return Optional.ofNullable(clazz.cast(this.localVolumeResourceData()));
            }
            case "S3MachineLearningModelResourceData": {
                return Optional.ofNullable(clazz.cast(this.s3MachineLearningModelResourceData()));
            }
            case "SageMakerMachineLearningModelResourceData": {
                return Optional.ofNullable(clazz.cast(this.sageMakerMachineLearningModelResourceData()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceDataContainerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private LocalDeviceResourceData localDeviceResourceData;
        private LocalVolumeResourceData localVolumeResourceData;
        private S3MachineLearningModelResourceData s3MachineLearningModelResourceData;
        private SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataContainer model) {
            this.localDeviceResourceData(model.localDeviceResourceData);
            this.localVolumeResourceData(model.localVolumeResourceData);
            this.s3MachineLearningModelResourceData(model.s3MachineLearningModelResourceData);
            this.sageMakerMachineLearningModelResourceData(model.sageMakerMachineLearningModelResourceData);
        }

        public final LocalDeviceResourceData.Builder getLocalDeviceResourceData() {
            return this.localDeviceResourceData != null ? this.localDeviceResourceData.toBuilder() : null;
        }

        @Override
        public final Builder localDeviceResourceData(LocalDeviceResourceData localDeviceResourceData) {
            this.localDeviceResourceData = localDeviceResourceData;
            return this;
        }

        public final void setLocalDeviceResourceData(LocalDeviceResourceData.BuilderImpl localDeviceResourceData) {
            this.localDeviceResourceData = localDeviceResourceData != null ? localDeviceResourceData.build() : null;
        }

        public final LocalVolumeResourceData.Builder getLocalVolumeResourceData() {
            return this.localVolumeResourceData != null ? this.localVolumeResourceData.toBuilder() : null;
        }

        @Override
        public final Builder localVolumeResourceData(LocalVolumeResourceData localVolumeResourceData) {
            this.localVolumeResourceData = localVolumeResourceData;
            return this;
        }

        public final void setLocalVolumeResourceData(LocalVolumeResourceData.BuilderImpl localVolumeResourceData) {
            this.localVolumeResourceData = localVolumeResourceData != null ? localVolumeResourceData.build() : null;
        }

        public final S3MachineLearningModelResourceData.Builder getS3MachineLearningModelResourceData() {
            return this.s3MachineLearningModelResourceData != null ? this.s3MachineLearningModelResourceData.toBuilder() : null;
        }

        @Override
        public final Builder s3MachineLearningModelResourceData(S3MachineLearningModelResourceData s3MachineLearningModelResourceData) {
            this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData;
            return this;
        }

        public final void setS3MachineLearningModelResourceData(S3MachineLearningModelResourceData.BuilderImpl s3MachineLearningModelResourceData) {
            this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData != null ? s3MachineLearningModelResourceData.build() : null;
        }

        public final SageMakerMachineLearningModelResourceData.Builder getSageMakerMachineLearningModelResourceData() {
            return this.sageMakerMachineLearningModelResourceData != null ? this.sageMakerMachineLearningModelResourceData.toBuilder() : null;
        }

        @Override
        public final Builder sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData sageMakerMachineLearningModelResourceData) {
            this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData;
            return this;
        }

        public final void setSageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData.BuilderImpl sageMakerMachineLearningModelResourceData) {
            this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData != null ? sageMakerMachineLearningModelResourceData.build() : null;
        }

        public ResourceDataContainer build() {
            return new ResourceDataContainer(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceDataContainer> {
        public Builder localDeviceResourceData(LocalDeviceResourceData var1);

        default public Builder localDeviceResourceData(Consumer<LocalDeviceResourceData.Builder> localDeviceResourceData) {
            return this.localDeviceResourceData((LocalDeviceResourceData)((LocalDeviceResourceData.Builder)LocalDeviceResourceData.builder().applyMutation(localDeviceResourceData)).build());
        }

        public Builder localVolumeResourceData(LocalVolumeResourceData var1);

        default public Builder localVolumeResourceData(Consumer<LocalVolumeResourceData.Builder> localVolumeResourceData) {
            return this.localVolumeResourceData((LocalVolumeResourceData)((LocalVolumeResourceData.Builder)LocalVolumeResourceData.builder().applyMutation(localVolumeResourceData)).build());
        }

        public Builder s3MachineLearningModelResourceData(S3MachineLearningModelResourceData var1);

        default public Builder s3MachineLearningModelResourceData(Consumer<S3MachineLearningModelResourceData.Builder> s3MachineLearningModelResourceData) {
            return this.s3MachineLearningModelResourceData((S3MachineLearningModelResourceData)((S3MachineLearningModelResourceData.Builder)S3MachineLearningModelResourceData.builder().applyMutation(s3MachineLearningModelResourceData)).build());
        }

        public Builder sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceData var1);

        default public Builder sageMakerMachineLearningModelResourceData(Consumer<SageMakerMachineLearningModelResourceData.Builder> sageMakerMachineLearningModelResourceData) {
            return this.sageMakerMachineLearningModelResourceData((SageMakerMachineLearningModelResourceData)((SageMakerMachineLearningModelResourceData.Builder)SageMakerMachineLearningModelResourceData.builder().applyMutation(sageMakerMachineLearningModelResourceData)).build());
        }
    }
}

