/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.Permission;
import software.amazon.awssdk.services.greengrass.transform.ResourceAccessPolicyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceAccessPolicy
implements StructuredPojo,
ToCopyableBuilder<Builder, ResourceAccessPolicy> {
    private final String permission;
    private final String resourceId;

    private ResourceAccessPolicy(BuilderImpl builder) {
        this.permission = builder.permission;
        this.resourceId = builder.resourceId;
    }

    public Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public String permissionAsString() {
        return this.permission;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceAccessPolicy)) {
            return false;
        }
        ResourceAccessPolicy other = (ResourceAccessPolicy)obj;
        return Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.resourceId(), other.resourceId());
    }

    public String toString() {
        return ToString.builder((String)"ResourceAccessPolicy").add("Permission", (Object)this.permissionAsString()).add("ResourceId", (Object)this.resourceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceAccessPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String permission;
        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceAccessPolicy model) {
            this.permission(model.permission);
            this.resourceId(model.resourceId);
        }

        public final String getPermission() {
            return this.permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public ResourceAccessPolicy build() {
            return new ResourceAccessPolicy(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceAccessPolicy> {
        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder resourceId(String var1);
    }
}

