/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.ResourceDataContainer;
import software.amazon.awssdk.services.greengrass.transform.ResourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements StructuredPojo,
ToCopyableBuilder<Builder, Resource> {
    private final String id;
    private final String name;
    private final ResourceDataContainer resourceDataContainer;

    private Resource(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.resourceDataContainer = builder.resourceDataContainer;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public ResourceDataContainer resourceDataContainer() {
        return this.resourceDataContainer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDataContainer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceDataContainer(), other.resourceDataContainer());
    }

    public String toString() {
        return ToString.builder((String)"Resource").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("ResourceDataContainer", (Object)this.resourceDataContainer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ResourceDataContainer": {
                return Optional.ofNullable(clazz.cast(this.resourceDataContainer()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private ResourceDataContainer resourceDataContainer;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.id(model.id);
            this.name(model.name);
            this.resourceDataContainer(model.resourceDataContainer);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ResourceDataContainer.Builder getResourceDataContainer() {
            return this.resourceDataContainer != null ? this.resourceDataContainer.toBuilder() : null;
        }

        @Override
        public final Builder resourceDataContainer(ResourceDataContainer resourceDataContainer) {
            this.resourceDataContainer = resourceDataContainer;
            return this;
        }

        public final void setResourceDataContainer(ResourceDataContainer.BuilderImpl resourceDataContainer) {
            this.resourceDataContainer = resourceDataContainer != null ? resourceDataContainer.build() : null;
        }

        public Resource build() {
            return new Resource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Resource> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder resourceDataContainer(ResourceDataContainer var1);

        default public Builder resourceDataContainer(Consumer<ResourceDataContainer.Builder> resourceDataContainer) {
            return this.resourceDataContainer((ResourceDataContainer)((ResourceDataContainer.Builder)ResourceDataContainer.builder().applyMutation(resourceDataContainer)).build());
        }
    }
}

