/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.GroupOwnerSetting;
import software.amazon.awssdk.services.greengrass.transform.LocalVolumeResourceDataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LocalVolumeResourceData
implements StructuredPojo,
ToCopyableBuilder<Builder, LocalVolumeResourceData> {
    private final String destinationPath;
    private final GroupOwnerSetting groupOwnerSetting;
    private final String sourcePath;

    private LocalVolumeResourceData(BuilderImpl builder) {
        this.destinationPath = builder.destinationPath;
        this.groupOwnerSetting = builder.groupOwnerSetting;
        this.sourcePath = builder.sourcePath;
    }

    public String destinationPath() {
        return this.destinationPath;
    }

    public GroupOwnerSetting groupOwnerSetting() {
        return this.groupOwnerSetting;
    }

    public String sourcePath() {
        return this.sourcePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupOwnerSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalVolumeResourceData)) {
            return false;
        }
        LocalVolumeResourceData other = (LocalVolumeResourceData)obj;
        return Objects.equals(this.destinationPath(), other.destinationPath()) && Objects.equals(this.groupOwnerSetting(), other.groupOwnerSetting()) && Objects.equals(this.sourcePath(), other.sourcePath());
    }

    public String toString() {
        return ToString.builder((String)"LocalVolumeResourceData").add("DestinationPath", (Object)this.destinationPath()).add("GroupOwnerSetting", (Object)this.groupOwnerSetting()).add("SourcePath", (Object)this.sourcePath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPath": {
                return Optional.ofNullable(clazz.cast(this.destinationPath()));
            }
            case "GroupOwnerSetting": {
                return Optional.ofNullable(clazz.cast(this.groupOwnerSetting()));
            }
            case "SourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocalVolumeResourceDataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationPath;
        private GroupOwnerSetting groupOwnerSetting;
        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(LocalVolumeResourceData model) {
            this.destinationPath(model.destinationPath);
            this.groupOwnerSetting(model.groupOwnerSetting);
            this.sourcePath(model.sourcePath);
        }

        public final String getDestinationPath() {
            return this.destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        public final GroupOwnerSetting.Builder getGroupOwnerSetting() {
            return this.groupOwnerSetting != null ? this.groupOwnerSetting.toBuilder() : null;
        }

        @Override
        public final Builder groupOwnerSetting(GroupOwnerSetting groupOwnerSetting) {
            this.groupOwnerSetting = groupOwnerSetting;
            return this;
        }

        public final void setGroupOwnerSetting(GroupOwnerSetting.BuilderImpl groupOwnerSetting) {
            this.groupOwnerSetting = groupOwnerSetting != null ? groupOwnerSetting.build() : null;
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public LocalVolumeResourceData build() {
            return new LocalVolumeResourceData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LocalVolumeResourceData> {
        public Builder destinationPath(String var1);

        public Builder groupOwnerSetting(GroupOwnerSetting var1);

        default public Builder groupOwnerSetting(Consumer<GroupOwnerSetting.Builder> groupOwnerSetting) {
            return this.groupOwnerSetting((GroupOwnerSetting)((GroupOwnerSetting.Builder)GroupOwnerSetting.builder().applyMutation(groupOwnerSetting)).build());
        }

        public Builder sourcePath(String var1);
    }
}

