/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFunctionDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, GetFunctionDefinitionVersionRequest> {
    private final String functionDefinitionId;
    private final String functionDefinitionVersionId;

    private GetFunctionDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.functionDefinitionId = builder.functionDefinitionId;
        this.functionDefinitionVersionId = builder.functionDefinitionVersionId;
    }

    public String functionDefinitionId() {
        return this.functionDefinitionId;
    }

    public String functionDefinitionVersionId() {
        return this.functionDefinitionVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionDefinitionVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFunctionDefinitionVersionRequest)) {
            return false;
        }
        GetFunctionDefinitionVersionRequest other = (GetFunctionDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.functionDefinitionId(), other.functionDefinitionId()) && Objects.equals(this.functionDefinitionVersionId(), other.functionDefinitionVersionId());
    }

    public String toString() {
        return ToString.builder((String)"GetFunctionDefinitionVersionRequest").add("FunctionDefinitionId", (Object)this.functionDefinitionId()).add("FunctionDefinitionVersionId", (Object)this.functionDefinitionVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.functionDefinitionId()));
            }
            case "FunctionDefinitionVersionId": {
                return Optional.ofNullable(clazz.cast(this.functionDefinitionVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String functionDefinitionId;
        private String functionDefinitionVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFunctionDefinitionVersionRequest model) {
            super(model);
            this.functionDefinitionId(model.functionDefinitionId);
            this.functionDefinitionVersionId(model.functionDefinitionVersionId);
        }

        public final String getFunctionDefinitionId() {
            return this.functionDefinitionId;
        }

        @Override
        public final Builder functionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
            return this;
        }

        public final void setFunctionDefinitionId(String functionDefinitionId) {
            this.functionDefinitionId = functionDefinitionId;
        }

        public final String getFunctionDefinitionVersionId() {
            return this.functionDefinitionVersionId;
        }

        @Override
        public final Builder functionDefinitionVersionId(String functionDefinitionVersionId) {
            this.functionDefinitionVersionId = functionDefinitionVersionId;
            return this;
        }

        public final void setFunctionDefinitionVersionId(String functionDefinitionVersionId) {
            this.functionDefinitionVersionId = functionDefinitionVersionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFunctionDefinitionVersionRequest build() {
            return new GetFunctionDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, GetFunctionDefinitionVersionRequest> {
        public Builder functionDefinitionId(String var1);

        public Builder functionDefinitionVersionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

