/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.greengrass.model.ResourceAccessPolicy;
import software.amazon.awssdk.services.greengrass.model.___listOfResourceAccessPolicyCopier;
import software.amazon.awssdk.services.greengrass.model.___mapOf__stringCopier;
import software.amazon.awssdk.services.greengrass.transform.FunctionConfigurationEnvironmentMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionConfigurationEnvironment
implements StructuredPojo,
ToCopyableBuilder<Builder, FunctionConfigurationEnvironment> {
    private final Boolean accessSysfs;
    private final List<ResourceAccessPolicy> resourceAccessPolicies;
    private final Map<String, String> variables;

    private FunctionConfigurationEnvironment(BuilderImpl builder) {
        this.accessSysfs = builder.accessSysfs;
        this.resourceAccessPolicies = builder.resourceAccessPolicies;
        this.variables = builder.variables;
    }

    public Boolean accessSysfs() {
        return this.accessSysfs;
    }

    public List<ResourceAccessPolicy> resourceAccessPolicies() {
        return this.resourceAccessPolicies;
    }

    public Map<String, String> variables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessSysfs());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfigurationEnvironment)) {
            return false;
        }
        FunctionConfigurationEnvironment other = (FunctionConfigurationEnvironment)obj;
        return Objects.equals(this.accessSysfs(), other.accessSysfs()) && Objects.equals(this.resourceAccessPolicies(), other.resourceAccessPolicies()) && Objects.equals(this.variables(), other.variables());
    }

    public String toString() {
        return ToString.builder((String)"FunctionConfigurationEnvironment").add("AccessSysfs", (Object)this.accessSysfs()).add("ResourceAccessPolicies", this.resourceAccessPolicies()).add("Variables", this.variables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessSysfs": {
                return Optional.ofNullable(clazz.cast(this.accessSysfs()));
            }
            case "ResourceAccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessPolicies()));
            }
            case "Variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionConfigurationEnvironmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean accessSysfs;
        private List<ResourceAccessPolicy> resourceAccessPolicies = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionConfigurationEnvironment model) {
            this.accessSysfs(model.accessSysfs);
            this.resourceAccessPolicies(model.resourceAccessPolicies);
            this.variables(model.variables);
        }

        public final Boolean getAccessSysfs() {
            return this.accessSysfs;
        }

        @Override
        public final Builder accessSysfs(Boolean accessSysfs) {
            this.accessSysfs = accessSysfs;
            return this;
        }

        public final void setAccessSysfs(Boolean accessSysfs) {
            this.accessSysfs = accessSysfs;
        }

        public final Collection<ResourceAccessPolicy.Builder> getResourceAccessPolicies() {
            return this.resourceAccessPolicies != null ? (Collection)this.resourceAccessPolicies.stream().map(ResourceAccessPolicy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAccessPolicies(Collection<ResourceAccessPolicy> resourceAccessPolicies) {
            this.resourceAccessPolicies = ___listOfResourceAccessPolicyCopier.copy(resourceAccessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAccessPolicies(ResourceAccessPolicy ... resourceAccessPolicies) {
            this.resourceAccessPolicies(Arrays.asList(resourceAccessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAccessPolicies(Consumer<ResourceAccessPolicy.Builder> ... resourceAccessPolicies) {
            this.resourceAccessPolicies(Stream.of(resourceAccessPolicies).map(c -> (ResourceAccessPolicy)((ResourceAccessPolicy.Builder)ResourceAccessPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAccessPolicies(Collection<ResourceAccessPolicy.BuilderImpl> resourceAccessPolicies) {
            this.resourceAccessPolicies = ___listOfResourceAccessPolicyCopier.copyFromBuilder(resourceAccessPolicies);
        }

        public final Map<String, String> getVariables() {
            return this.variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = ___mapOf__stringCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = ___mapOf__stringCopier.copy(variables);
        }

        public FunctionConfigurationEnvironment build() {
            return new FunctionConfigurationEnvironment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FunctionConfigurationEnvironment> {
        public Builder accessSysfs(Boolean var1);

        public Builder resourceAccessPolicies(Collection<ResourceAccessPolicy> var1);

        public Builder resourceAccessPolicies(ResourceAccessPolicy ... var1);

        public Builder resourceAccessPolicies(Consumer<ResourceAccessPolicy.Builder> ... var1);

        public Builder variables(Map<String, String> var1);
    }
}

