/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.Resource;
import software.amazon.awssdk.services.greengrass.model.___listOfResourceCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateResourceDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String resourceDefinitionId;
    private final List<Resource> resources;

    private CreateResourceDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.resourceDefinitionId = builder.resourceDefinitionId;
        this.resources = builder.resources;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String resourceDefinitionId() {
        return this.resourceDefinitionId;
    }

    public List<Resource> resources() {
        return this.resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceDefinitionVersionRequest)) {
            return false;
        }
        CreateResourceDefinitionVersionRequest other = (CreateResourceDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.resourceDefinitionId(), other.resourceDefinitionId()) && Objects.equals(this.resources(), other.resources());
    }

    public String toString() {
        return ToString.builder((String)"CreateResourceDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("ResourceDefinitionId", (Object)this.resourceDefinitionId()).add("Resources", this.resources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.ofNullable(clazz.cast(this.amznClientToken()));
            }
            case "ResourceDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.resourceDefinitionId()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String resourceDefinitionId;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.resourceDefinitionId(model.resourceDefinitionId);
            this.resources(model.resources);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getResourceDefinitionId() {
            return this.resourceDefinitionId;
        }

        @Override
        public final Builder resourceDefinitionId(String resourceDefinitionId) {
            this.resourceDefinitionId = resourceDefinitionId;
            return this;
        }

        public final void setResourceDefinitionId(String resourceDefinitionId) {
            this.resourceDefinitionId = resourceDefinitionId;
        }

        public final Collection<Resource.Builder> getResources() {
            return this.resources != null ? (Collection)this.resources.stream().map(Resource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ___listOfResourceCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ___listOfResourceCopier.copyFromBuilder(resources);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceDefinitionVersionRequest build() {
            return new CreateResourceDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateResourceDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder resourceDefinitionId(String var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

