/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.GroupVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GroupVersionMarshaller {
    private static final MarshallingInfo<String> COREDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> DEVICEDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> FUNCTIONDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FunctionDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> LOGGERDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggerDefinitionVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> SUBSCRIPTIONDEFINITIONVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionDefinitionVersionArn").isBinary(false).build();
    private static final GroupVersionMarshaller INSTANCE = new GroupVersionMarshaller();

    private GroupVersionMarshaller() {
    }

    public static GroupVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GroupVersion groupVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)groupVersion, (String)"groupVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)groupVersion.coreDefinitionVersionArn(), COREDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)groupVersion.deviceDefinitionVersionArn(), DEVICEDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)groupVersion.functionDefinitionVersionArn(), FUNCTIONDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)groupVersion.loggerDefinitionVersionArn(), LOGGERDEFINITIONVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)groupVersion.subscriptionDefinitionVersionArn(), SUBSCRIPTIONDEFINITIONVERSIONARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

