/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.FunctionDefinitionVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FunctionDefinitionVersionMarshaller {
    private static final MarshallingInfo<List> FUNCTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Functions").isBinary(false).build();
    private static final FunctionDefinitionVersionMarshaller INSTANCE = new FunctionDefinitionVersionMarshaller();

    private FunctionDefinitionVersionMarshaller() {
    }

    public static FunctionDefinitionVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionDefinitionVersion functionDefinitionVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)functionDefinitionVersion, (String)"functionDefinitionVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(functionDefinitionVersion.functions(), FUNCTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

