/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.FunctionConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FunctionConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").isBinary(false).build();
    private static final MarshallingInfo<String> EXECARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecArgs").isBinary(false).build();
    private static final MarshallingInfo<String> EXECUTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Executable").isBinary(false).build();
    private static final MarshallingInfo<Integer> MEMORYSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemorySize").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PINNED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pinned").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timeout").isBinary(false).build();
    private static final FunctionConfigurationMarshaller INSTANCE = new FunctionConfigurationMarshaller();

    private FunctionConfigurationMarshaller() {
    }

    public static FunctionConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FunctionConfiguration functionConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)functionConfiguration, (String)"functionConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)functionConfiguration.environment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.execArgs(), EXECARGS_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.executable(), EXECUTABLE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.memorySize(), MEMORYSIZE_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.pinned(), PINNED_BINDING);
            protocolMarshaller.marshall((Object)functionConfiguration.timeout(), TIMEOUT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

