/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.ErrorDetail;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ErrorDetailMarshaller {
    private static final MarshallingInfo<String> DETAILEDERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetailedErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> DETAILEDERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetailedErrorMessage").isBinary(false).build();
    private static final ErrorDetailMarshaller INSTANCE = new ErrorDetailMarshaller();

    private ErrorDetailMarshaller() {
    }

    public static ErrorDetailMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ErrorDetail errorDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)errorDetail, (String)"errorDetail");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)errorDetail.detailedErrorCode(), DETAILEDERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)errorDetail.detailedErrorMessage(), DETAILEDERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

