/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.greengrass.model.Deployment;
import software.amazon.awssdk.services.greengrass.model.DeploymentsCopier;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListDeploymentsResponse> {
    private final List<Deployment> deployments;
    private final String nextToken;

    private ListDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
        this.nextToken = builder.nextToken;
    }

    public List<Deployment> deployments() {
        return this.deployments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deployments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsResponse)) {
            return false;
        }
        ListDeploymentsResponse other = (ListDeploymentsResponse)((Object)obj);
        return Objects.equals(this.deployments(), other.deployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentsResponse").add("Deployments", this.deployments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deployments": {
                return Optional.ofNullable(clazz.cast(this.deployments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private List<Deployment> deployments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsResponse model) {
            super(model);
            this.deployments(model.deployments);
            this.nextToken(model.nextToken);
        }

        public final Collection<Deployment.Builder> getDeployments() {
            return this.deployments != null ? (Collection)this.deployments.stream().map(Deployment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<Deployment.Builder> ... deployments) {
            this.deployments(Stream.of(deployments).map(c -> (Deployment)((Deployment.Builder)Deployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentsCopier.copyFromBuilder(deployments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentsResponse build() {
            return new ListDeploymentsResponse(this);
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    CopyableBuilder<Builder, ListDeploymentsResponse> {
        public Builder deployments(Collection<Deployment> var1);

        public Builder deployments(Deployment ... var1);

        public Builder deployments(Consumer<Deployment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

