/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.DeviceDefinitionVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeviceDefinitionVersionMarshaller {
    private static final MarshallingInfo<List> DEVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Devices").isBinary(false).build();
    private static final DeviceDefinitionVersionMarshaller INSTANCE = new DeviceDefinitionVersionMarshaller();

    private DeviceDefinitionVersionMarshaller() {
    }

    public static DeviceDefinitionVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeviceDefinitionVersion deviceDefinitionVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deviceDefinitionVersion, (String)"deviceDefinitionVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(deviceDefinitionVersion.devices(), DEVICES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

