/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.greengrass.model.DefinitionInformation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DefinitionInformationMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> LASTUPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> LATESTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").isBinary(false).build();
    private static final MarshallingInfo<String> LATESTVERSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersionArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final DefinitionInformationMarshaller INSTANCE = new DefinitionInformationMarshaller();

    private DefinitionInformationMarshaller() {
    }

    public static DefinitionInformationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DefinitionInformation definitionInformation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)definitionInformation, (String)"definitionInformation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)definitionInformation.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)definitionInformation.creationTimestamp(), CREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)definitionInformation.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)definitionInformation.lastUpdatedTimestamp(), LASTUPDATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)definitionInformation.latestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall((Object)definitionInformation.latestVersionArn(), LATESTVERSIONARN_BINDING);
            protocolMarshaller.marshall((Object)definitionInformation.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

