/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.transform.SubscriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Subscription
implements StructuredPojo,
ToCopyableBuilder<Builder, Subscription> {
    private final String id;
    private final String source;
    private final String subject;
    private final String target;

    private Subscription(BuilderImpl builder) {
        this.id = builder.id;
        this.source = builder.source;
        this.subject = builder.subject;
        this.target = builder.target;
    }

    public String id() {
        return this.id;
    }

    public String source() {
        return this.source;
    }

    public String subject() {
        return this.subject;
    }

    public String target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.target(), other.target());
    }

    public String toString() {
        return ToString.builder((String)"Subscription").add("Id", (Object)this.id()).add("Source", (Object)this.source()).add("Subject", (Object)this.subject()).add("Target", (Object)this.target()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "Subject": {
                return Optional.of(clazz.cast(this.subject()));
            }
            case "Target": {
                return Optional.of(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String source;
        private String subject;
        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.id(model.id);
            this.source(model.source);
            this.subject(model.subject);
            this.target(model.target);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public Subscription build() {
            return new Subscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subscription> {
        public Builder id(String var1);

        public Builder source(String var1);

        public Builder subject(String var1);

        public Builder target(String var1);
    }
}

