/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.greengrass.model.DefinitionInformation;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.ListOfDefinitionInformationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeviceDefinitionsResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, ListDeviceDefinitionsResponse> {
    private final List<DefinitionInformation> definitions;
    private final String nextToken;

    private ListDeviceDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.definitions = builder.definitions;
        this.nextToken = builder.nextToken;
    }

    public List<DefinitionInformation> definitions() {
        return this.definitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceDefinitionsResponse)) {
            return false;
        }
        ListDeviceDefinitionsResponse other = (ListDeviceDefinitionsResponse)((Object)obj);
        return Objects.equals(this.definitions(), other.definitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeviceDefinitionsResponse").add("Definitions", this.definitions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Definitions": {
                return Optional.of(clazz.cast(this.definitions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private List<DefinitionInformation> definitions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceDefinitionsResponse model) {
            super(model);
            this.definitions(model.definitions);
            this.nextToken(model.nextToken);
        }

        public final Collection<DefinitionInformation.Builder> getDefinitions() {
            return this.definitions != null ? (Collection)this.definitions.stream().map(DefinitionInformation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder definitions(Collection<DefinitionInformation> definitions) {
            this.definitions = ListOfDefinitionInformationCopier.copy(definitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(DefinitionInformation ... definitions) {
            this.definitions(Arrays.asList(definitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder definitions(Consumer<DefinitionInformation.Builder> ... definitions) {
            this.definitions(Stream.of(definitions).map(c -> (DefinitionInformation)((DefinitionInformation.Builder)DefinitionInformation.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDefinitions(Collection<DefinitionInformation.BuilderImpl> definitions) {
            this.definitions = ListOfDefinitionInformationCopier.copyFromBuilder(definitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeviceDefinitionsResponse build() {
            return new ListDeviceDefinitionsResponse(this);
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    CopyableBuilder<Builder, ListDeviceDefinitionsResponse> {
        public Builder definitions(Collection<DefinitionInformation> var1);

        public Builder definitions(DefinitionInformation ... var1);

        public Builder definitions(Consumer<DefinitionInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

