/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfLoggerCopier;
import software.amazon.awssdk.services.greengrass.model.Logger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateLoggerDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateLoggerDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String loggerDefinitionId;
    private final List<Logger> loggers;

    private CreateLoggerDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.loggerDefinitionId = builder.loggerDefinitionId;
        this.loggers = builder.loggers;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String loggerDefinitionId() {
        return this.loggerDefinitionId;
    }

    public List<Logger> loggers() {
        return this.loggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggerDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoggerDefinitionVersionRequest)) {
            return false;
        }
        CreateLoggerDefinitionVersionRequest other = (CreateLoggerDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.loggerDefinitionId(), other.loggerDefinitionId()) && Objects.equals(this.loggers(), other.loggers());
    }

    public String toString() {
        return ToString.builder((String)"CreateLoggerDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("LoggerDefinitionId", (Object)this.loggerDefinitionId()).add("Loggers", this.loggers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "LoggerDefinitionId": {
                return Optional.of(clazz.cast(this.loggerDefinitionId()));
            }
            case "Loggers": {
                return Optional.of(clazz.cast(this.loggers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String loggerDefinitionId;
        private List<Logger> loggers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoggerDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.loggerDefinitionId(model.loggerDefinitionId);
            this.loggers(model.loggers);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getLoggerDefinitionId() {
            return this.loggerDefinitionId;
        }

        @Override
        public final Builder loggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
            return this;
        }

        public final void setLoggerDefinitionId(String loggerDefinitionId) {
            this.loggerDefinitionId = loggerDefinitionId;
        }

        public final Collection<Logger.Builder> getLoggers() {
            return this.loggers != null ? (Collection)this.loggers.stream().map(Logger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loggers(Collection<Logger> loggers) {
            this.loggers = ListOfLoggerCopier.copy(loggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Logger ... loggers) {
            this.loggers(Arrays.asList(loggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loggers(Consumer<Logger.Builder> ... loggers) {
            this.loggers(Stream.of(loggers).map(c -> (Logger)((Logger.Builder)Logger.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoggers(Collection<Logger.BuilderImpl> loggers) {
            this.loggers = ListOfLoggerCopier.copyFromBuilder(loggers);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateLoggerDefinitionVersionRequest build() {
            return new CreateLoggerDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateLoggerDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder loggerDefinitionId(String var1);

        public Builder loggers(Collection<Logger> var1);

        public Builder loggers(Logger ... var1);

        public Builder loggers(Consumer<Logger.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

