/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.DeploymentType;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeploymentRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private final String amznClientToken;
    private final String deploymentId;
    private final String deploymentType;
    private final String groupId;
    private final String groupVersionId;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.deploymentId = builder.deploymentId;
        this.deploymentType = builder.deploymentType;
        this.groupId = builder.groupId;
        this.groupVersionId = builder.groupVersionId;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupVersionId() {
        return this.groupVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupVersionId(), other.groupVersionId());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("DeploymentId", (Object)this.deploymentId()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("GroupId", (Object)this.groupId()).add("GroupVersionId", (Object)this.groupVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "DeploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "DeploymentType": {
                return Optional.of(clazz.cast(this.deploymentTypeAsString()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "GroupVersionId": {
                return Optional.of(clazz.cast(this.groupVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String deploymentId;
        private String deploymentType;
        private String groupId;
        private String groupVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.deploymentId(model.deploymentId);
            this.deploymentType(model.deploymentType);
            this.groupId(model.groupId);
            this.groupVersionId(model.groupVersionId);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupVersionId() {
            return this.groupVersionId;
        }

        @Override
        public final Builder groupVersionId(String groupVersionId) {
            this.groupVersionId = groupVersionId;
            return this;
        }

        public final void setGroupVersionId(String groupVersionId) {
            this.groupVersionId = groupVersionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder amznClientToken(String var1);

        public Builder deploymentId(String var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder groupId(String var1);

        public Builder groupVersionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

