/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.greengrass.model.Core;
import software.amazon.awssdk.services.greengrass.model.GreengrassRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfCoreCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCoreDefinitionVersionRequest
extends GreengrassRequest
implements ToCopyableBuilder<Builder, CreateCoreDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String coreDefinitionId;
    private final List<Core> cores;

    private CreateCoreDefinitionVersionRequest(BuilderImpl builder) {
        super(builder);
        this.amznClientToken = builder.amznClientToken;
        this.coreDefinitionId = builder.coreDefinitionId;
        this.cores = builder.cores;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String coreDefinitionId() {
        return this.coreDefinitionId;
    }

    public List<Core> cores() {
        return this.cores;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amznClientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cores());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCoreDefinitionVersionRequest)) {
            return false;
        }
        CreateCoreDefinitionVersionRequest other = (CreateCoreDefinitionVersionRequest)((Object)obj);
        return Objects.equals(this.amznClientToken(), other.amznClientToken()) && Objects.equals(this.coreDefinitionId(), other.coreDefinitionId()) && Objects.equals(this.cores(), other.cores());
    }

    public String toString() {
        return ToString.builder((String)"CreateCoreDefinitionVersionRequest").add("AmznClientToken", (Object)this.amznClientToken()).add("CoreDefinitionId", (Object)this.coreDefinitionId()).add("Cores", this.cores()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmznClientToken": {
                return Optional.of(clazz.cast(this.amznClientToken()));
            }
            case "CoreDefinitionId": {
                return Optional.of(clazz.cast(this.coreDefinitionId()));
            }
            case "Cores": {
                return Optional.of(clazz.cast(this.cores()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends GreengrassRequest.BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String coreDefinitionId;
        private List<Core> cores;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCoreDefinitionVersionRequest model) {
            super(model);
            this.amznClientToken(model.amznClientToken);
            this.coreDefinitionId(model.coreDefinitionId);
            this.cores(model.cores);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getCoreDefinitionId() {
            return this.coreDefinitionId;
        }

        @Override
        public final Builder coreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        public final void setCoreDefinitionId(String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
        }

        public final Collection<Core.Builder> getCores() {
            return this.cores != null ? (Collection)this.cores.stream().map(Core::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cores(Collection<Core> cores) {
            this.cores = ListOfCoreCopier.copy(cores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Core ... cores) {
            this.cores(Arrays.asList(cores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cores(Consumer<Core.Builder> ... cores) {
            this.cores(Stream.of(cores).map(c -> (Core)((Core.Builder)Core.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCores(Collection<Core.BuilderImpl> cores) {
            this.cores = ListOfCoreCopier.copyFromBuilder(cores);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateCoreDefinitionVersionRequest build() {
            return new CreateCoreDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends GreengrassRequest.Builder,
    CopyableBuilder<Builder, CreateCoreDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder coreDefinitionId(String var1);

        public Builder cores(Collection<Core> var1);

        public Builder cores(Core ... var1);

        public Builder cores(Consumer<Core.Builder> ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

