/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.greengrass.model.ListOfSubscriptionCopier;
import software.amazon.awssdk.services.greengrass.model.Subscription;
import software.amazon.awssdk.services.greengrass.transform.SubscriptionDefinitionVersionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubscriptionDefinitionVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, SubscriptionDefinitionVersion> {
    private final List<Subscription> subscriptions;

    private SubscriptionDefinitionVersion(BuilderImpl builder) {
        this.subscriptions = builder.subscriptions;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptions() == null ? 0 : this.subscriptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionDefinitionVersion)) {
            return false;
        }
        SubscriptionDefinitionVersion other = (SubscriptionDefinitionVersion)obj;
        if (other.subscriptions() == null ^ this.subscriptions() == null) {
            return false;
        }
        return other.subscriptions() == null || other.subscriptions().equals(this.subscriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptions() != null) {
            sb.append("Subscriptions: ").append(this.subscriptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Subscription> subscriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionDefinitionVersion model) {
            this.setSubscriptions(model.subscriptions);
        }

        public final Collection<Subscription> getSubscriptions() {
            return this.subscriptions;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            if (this.subscriptions == null) {
                this.subscriptions = new ArrayList<Subscription>(subscriptions.length);
            }
            for (Subscription e : subscriptions) {
                this.subscriptions.add(e);
            }
            return this;
        }

        public final void setSubscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copy(subscriptions);
        }

        @SafeVarargs
        public final void setSubscriptions(Subscription ... subscriptions) {
            if (this.subscriptions == null) {
                this.subscriptions = new ArrayList<Subscription>(subscriptions.length);
            }
            for (Subscription e : subscriptions) {
                this.subscriptions.add(e);
            }
        }

        public SubscriptionDefinitionVersion build() {
            return new SubscriptionDefinitionVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubscriptionDefinitionVersion> {
        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);
    }
}

