/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.greengrass.model.ListOfSubscriptionCopier;
import software.amazon.awssdk.services.greengrass.model.Subscription;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateSubscriptionDefinitionVersionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateSubscriptionDefinitionVersionRequest> {
    private final String amznClientToken;
    private final String subscriptionDefinitionId;
    private final List<Subscription> subscriptions;

    private CreateSubscriptionDefinitionVersionRequest(BuilderImpl builder) {
        this.amznClientToken = builder.amznClientToken;
        this.subscriptionDefinitionId = builder.subscriptionDefinitionId;
        this.subscriptions = builder.subscriptions;
    }

    public String amznClientToken() {
        return this.amznClientToken;
    }

    public String subscriptionDefinitionId() {
        return this.subscriptionDefinitionId;
    }

    public List<Subscription> subscriptions() {
        return this.subscriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.amznClientToken() == null ? 0 : this.amznClientToken().hashCode());
        hashCode = 31 * hashCode + (this.subscriptionDefinitionId() == null ? 0 : this.subscriptionDefinitionId().hashCode());
        hashCode = 31 * hashCode + (this.subscriptions() == null ? 0 : this.subscriptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionDefinitionVersionRequest)) {
            return false;
        }
        CreateSubscriptionDefinitionVersionRequest other = (CreateSubscriptionDefinitionVersionRequest)((Object)obj);
        if (other.amznClientToken() == null ^ this.amznClientToken() == null) {
            return false;
        }
        if (other.amznClientToken() != null && !other.amznClientToken().equals(this.amznClientToken())) {
            return false;
        }
        if (other.subscriptionDefinitionId() == null ^ this.subscriptionDefinitionId() == null) {
            return false;
        }
        if (other.subscriptionDefinitionId() != null && !other.subscriptionDefinitionId().equals(this.subscriptionDefinitionId())) {
            return false;
        }
        if (other.subscriptions() == null ^ this.subscriptions() == null) {
            return false;
        }
        return other.subscriptions() == null || other.subscriptions().equals(this.subscriptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.amznClientToken() != null) {
            sb.append("AmznClientToken: ").append(this.amznClientToken()).append(",");
        }
        if (this.subscriptionDefinitionId() != null) {
            sb.append("SubscriptionDefinitionId: ").append(this.subscriptionDefinitionId()).append(",");
        }
        if (this.subscriptions() != null) {
            sb.append("Subscriptions: ").append(this.subscriptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String amznClientToken;
        private String subscriptionDefinitionId;
        private List<Subscription> subscriptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionDefinitionVersionRequest model) {
            this.setAmznClientToken(model.amznClientToken);
            this.setSubscriptionDefinitionId(model.subscriptionDefinitionId);
            this.setSubscriptions(model.subscriptions);
        }

        public final String getAmznClientToken() {
            return this.amznClientToken;
        }

        @Override
        public final Builder amznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
            return this;
        }

        public final void setAmznClientToken(String amznClientToken) {
            this.amznClientToken = amznClientToken;
        }

        public final String getSubscriptionDefinitionId() {
            return this.subscriptionDefinitionId;
        }

        @Override
        public final Builder subscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
            return this;
        }

        public final void setSubscriptionDefinitionId(String subscriptionDefinitionId) {
            this.subscriptionDefinitionId = subscriptionDefinitionId;
        }

        public final Collection<Subscription> getSubscriptions() {
            return this.subscriptions;
        }

        @Override
        public final Builder subscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copy(subscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptions(Subscription ... subscriptions) {
            if (this.subscriptions == null) {
                this.subscriptions = new ArrayList<Subscription>(subscriptions.length);
            }
            for (Subscription e : subscriptions) {
                this.subscriptions.add(e);
            }
            return this;
        }

        public final void setSubscriptions(Collection<Subscription> subscriptions) {
            this.subscriptions = ListOfSubscriptionCopier.copy(subscriptions);
        }

        @SafeVarargs
        public final void setSubscriptions(Subscription ... subscriptions) {
            if (this.subscriptions == null) {
                this.subscriptions = new ArrayList<Subscription>(subscriptions.length);
            }
            for (Subscription e : subscriptions) {
                this.subscriptions.add(e);
            }
        }

        public CreateSubscriptionDefinitionVersionRequest build() {
            return new CreateSubscriptionDefinitionVersionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateSubscriptionDefinitionVersionRequest> {
        public Builder amznClientToken(String var1);

        public Builder subscriptionDefinitionId(String var1);

        public Builder subscriptions(Collection<Subscription> var1);

        public Builder subscriptions(Subscription ... var1);
    }
}

