/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.Role;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceAccountSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceAccountSummary> {
    private static final SdkField<String> GRAFANA_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grafanaRole").getter(ServiceAccountSummary.getter(ServiceAccountSummary::grafanaRoleAsString)).setter(ServiceAccountSummary.setter(Builder::grafanaRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaRole").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ServiceAccountSummary.getter(ServiceAccountSummary::id)).setter(ServiceAccountSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> IS_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("isDisabled").getter(ServiceAccountSummary.getter(ServiceAccountSummary::isDisabled)).setter(ServiceAccountSummary.setter(Builder::isDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDisabled").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ServiceAccountSummary.getter(ServiceAccountSummary::name)).setter(ServiceAccountSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAFANA_ROLE_FIELD, ID_FIELD, IS_DISABLED_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceAccountSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String grafanaRole;
    private final String id;
    private final String isDisabled;
    private final String name;

    private ServiceAccountSummary(BuilderImpl builder) {
        this.grafanaRole = builder.grafanaRole;
        this.id = builder.id;
        this.isDisabled = builder.isDisabled;
        this.name = builder.name;
    }

    public final Role grafanaRole() {
        return Role.fromValue(this.grafanaRole);
    }

    public final String grafanaRoleAsString() {
        return this.grafanaRole;
    }

    public final String id() {
        return this.id;
    }

    public final String isDisabled() {
        return this.isDisabled;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.grafanaRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountSummary)) {
            return false;
        }
        ServiceAccountSummary other = (ServiceAccountSummary)obj;
        return Objects.equals(this.grafanaRoleAsString(), other.grafanaRoleAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.isDisabled(), other.isDisabled()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceAccountSummary").add("GrafanaRole", (Object)this.grafanaRoleAsString()).add("Id", (Object)this.id()).add("IsDisabled", (Object)this.isDisabled()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "grafanaRole": {
                return Optional.ofNullable(clazz.cast(this.grafanaRoleAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "isDisabled": {
                return Optional.ofNullable(clazz.cast(this.isDisabled()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("grafanaRole", GRAFANA_ROLE_FIELD);
        map.put("id", ID_FIELD);
        map.put("isDisabled", IS_DISABLED_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceAccountSummary, T> g) {
        return obj -> g.apply((ServiceAccountSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String grafanaRole;
        private String id;
        private String isDisabled;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountSummary model) {
            this.grafanaRole(model.grafanaRole);
            this.id(model.id);
            this.isDisabled(model.isDisabled);
            this.name(model.name);
        }

        public final String getGrafanaRole() {
            return this.grafanaRole;
        }

        public final void setGrafanaRole(String grafanaRole) {
            this.grafanaRole = grafanaRole;
        }

        @Override
        public final Builder grafanaRole(String grafanaRole) {
            this.grafanaRole = grafanaRole;
            return this;
        }

        @Override
        public final Builder grafanaRole(Role grafanaRole) {
            this.grafanaRole(grafanaRole == null ? null : grafanaRole.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIsDisabled() {
            return this.isDisabled;
        }

        public final void setIsDisabled(String isDisabled) {
            this.isDisabled = isDisabled;
        }

        @Override
        public final Builder isDisabled(String isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public ServiceAccountSummary build() {
            return new ServiceAccountSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceAccountSummary> {
        public Builder grafanaRole(String var1);

        public Builder grafanaRole(Role var1);

        public Builder id(String var1);

        public Builder isDisabled(String var1);

        public Builder name(String var1);
    }
}

