/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspaceConfigurationResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, DescribeWorkspaceConfigurationResponse> {
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuration").getter(DescribeWorkspaceConfigurationResponse.getter(DescribeWorkspaceConfigurationResponse::configuration)).setter(DescribeWorkspaceConfigurationResponse.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), JsonValueTrait.create()}).build();
    private static final SdkField<String> GRAFANA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grafanaVersion").getter(DescribeWorkspaceConfigurationResponse.getter(DescribeWorkspaceConfigurationResponse::grafanaVersion)).setter(DescribeWorkspaceConfigurationResponse.setter(Builder::grafanaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, GRAFANA_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeWorkspaceConfigurationResponse.memberNameToFieldInitializer();
    private final String configuration;
    private final String grafanaVersion;

    private DescribeWorkspaceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.grafanaVersion = builder.grafanaVersion;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final String grafanaVersion() {
        return this.grafanaVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.grafanaVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspaceConfigurationResponse)) {
            return false;
        }
        DescribeWorkspaceConfigurationResponse other = (DescribeWorkspaceConfigurationResponse)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.grafanaVersion(), other.grafanaVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspaceConfigurationResponse").add("Configuration", (Object)this.configuration()).add("GrafanaVersion", (Object)this.grafanaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "grafanaVersion": {
                return Optional.ofNullable(clazz.cast(this.grafanaVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("grafanaVersion", GRAFANA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspaceConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeWorkspaceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private String configuration;
        private String grafanaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspaceConfigurationResponse model) {
            super(model);
            this.configuration(model.configuration);
            this.grafanaVersion(model.grafanaVersion);
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getGrafanaVersion() {
            return this.grafanaVersion;
        }

        public final void setGrafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
        }

        @Override
        public final Builder grafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
            return this;
        }

        @Override
        public DescribeWorkspaceConfigurationResponse build() {
            return new DescribeWorkspaceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspaceConfigurationResponse> {
        public Builder configuration(String var1);

        public Builder grafanaVersion(String var1);
    }
}

