/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspaceApiKeyResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, CreateWorkspaceApiKeyResponse> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(CreateWorkspaceApiKeyResponse.getter(CreateWorkspaceApiKeyResponse::key)).setter(CreateWorkspaceApiKeyResponse.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyName").getter(CreateWorkspaceApiKeyResponse.getter(CreateWorkspaceApiKeyResponse::keyName)).setter(CreateWorkspaceApiKeyResponse.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(CreateWorkspaceApiKeyResponse.getter(CreateWorkspaceApiKeyResponse::workspaceId)).setter(CreateWorkspaceApiKeyResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, KEY_NAME_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("key", KEY_FIELD);
            this.put("keyName", KEY_NAME_FIELD);
            this.put("workspaceId", WORKSPACE_ID_FIELD);
        }
    });
    private final String key;
    private final String keyName;
    private final String workspaceId;

    private CreateWorkspaceApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.keyName = builder.keyName;
        this.workspaceId = builder.workspaceId;
    }

    public final String key() {
        return this.key;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceApiKeyResponse)) {
            return false;
        }
        CreateWorkspaceApiKeyResponse other = (CreateWorkspaceApiKeyResponse)((Object)obj);
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspaceApiKeyResponse").add("Key", (Object)(this.key() == null ? null : "*** Sensitive Data Redacted ***")).add("KeyName", (Object)this.keyName()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "keyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceApiKeyResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceApiKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private String key;
        private String keyName;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceApiKeyResponse model) {
            super(model);
            this.key(model.key);
            this.keyName(model.keyName);
            this.workspaceId(model.workspaceId);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public CreateWorkspaceApiKeyResponse build() {
            return new CreateWorkspaceApiKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspaceApiKeyResponse> {
        public Builder key(String var1);

        public Builder keyName(String var1);

        public Builder workspaceId(String var1);
    }
}

