/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotificationDestinationType {
    SNS("SNS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotificationDestinationType> VALUE_MAP;
    private final String value;

    private NotificationDestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotificationDestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotificationDestinationType> knownValues() {
        EnumSet<NotificationDestinationType> knownValues = EnumSet.allOf(NotificationDestinationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotificationDestinationType.class, NotificationDestinationType::toString);
    }
}

