/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.grafana.DefaultGrafanaAsyncClient;
import software.amazon.awssdk.services.grafana.DefaultGrafanaBaseClientBuilder;
import software.amazon.awssdk.services.grafana.GrafanaAsyncClient;
import software.amazon.awssdk.services.grafana.GrafanaAsyncClientBuilder;
import software.amazon.awssdk.services.grafana.GrafanaServiceClientConfiguration;
import software.amazon.awssdk.services.grafana.endpoints.GrafanaEndpointProvider;

@SdkInternalApi
final class DefaultGrafanaAsyncClientBuilder
extends DefaultGrafanaBaseClientBuilder<GrafanaAsyncClientBuilder, GrafanaAsyncClient>
implements GrafanaAsyncClientBuilder {
    DefaultGrafanaAsyncClientBuilder() {
    }

    @Override
    public DefaultGrafanaAsyncClientBuilder endpointProvider(GrafanaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GrafanaAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGrafanaAsyncClientBuilder.validateClientOptions(clientConfiguration);
        GrafanaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGrafanaAsyncClient client = new DefaultGrafanaAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GrafanaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GrafanaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

