/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.grafana.endpoints.GrafanaEndpointParams;
import software.amazon.awssdk.services.grafana.endpoints.GrafanaEndpointProvider;
import software.amazon.awssdk.services.grafana.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.grafana.endpoints.internal.Condition;
import software.amazon.awssdk.services.grafana.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.grafana.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.grafana.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.grafana.endpoints.internal.Expr;
import software.amazon.awssdk.services.grafana.endpoints.internal.FnNode;
import software.amazon.awssdk.services.grafana.endpoints.internal.Identifier;
import software.amazon.awssdk.services.grafana.endpoints.internal.Parameter;
import software.amazon.awssdk.services.grafana.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.grafana.endpoints.internal.Parameters;
import software.amazon.awssdk.services.grafana.endpoints.internal.Rule;
import software.amazon.awssdk.services.grafana.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class DefaultGrafanaEndpointProvider
implements GrafanaEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultGrafanaEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(GrafanaEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultGrafanaEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(GrafanaEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_4() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_2() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_3(), DefaultGrafanaEndpointProvider.endpointRule_4()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_1(), DefaultGrafanaEndpointProvider.endpointRule_2()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://grafana-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_10() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_11()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_12() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_9(), DefaultGrafanaEndpointProvider.endpointRule_12()));
    }

    private static Rule endpointRule_16() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://grafana-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_15() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_16()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_14(), DefaultGrafanaEndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://grafana.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_20()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_18() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_19(), DefaultGrafanaEndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-northeast-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.ap-northeast-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-northeast-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.ap-northeast-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_26() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-southeast-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.ap-southeast-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_27() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("ap-southeast-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.ap-southeast-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_28() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-central-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.eu-central-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_29() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.eu-west-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_30() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("eu-west-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.eu-west-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_31() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.us-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_32() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.us-east-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_33() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-west-2"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://grafana.us-west-2.amazonaws.com")).build());
    }

    private static Rule endpointRule_34() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://grafana.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_23() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_24(), DefaultGrafanaEndpointProvider.endpointRule_25(), DefaultGrafanaEndpointProvider.endpointRule_26(), DefaultGrafanaEndpointProvider.endpointRule_27(), DefaultGrafanaEndpointProvider.endpointRule_28(), DefaultGrafanaEndpointProvider.endpointRule_29(), DefaultGrafanaEndpointProvider.endpointRule_30(), DefaultGrafanaEndpointProvider.endpointRule_31(), DefaultGrafanaEndpointProvider.endpointRule_32(), DefaultGrafanaEndpointProvider.endpointRule_33(), DefaultGrafanaEndpointProvider.endpointRule_34()));
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_8(), DefaultGrafanaEndpointProvider.endpointRule_13(), DefaultGrafanaEndpointProvider.endpointRule_18(), DefaultGrafanaEndpointProvider.endpointRule_23()));
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_7()));
    }

    private static Rule endpointRule_35() {
        return Rule.builder().error("Invalid Configuration: Missing Region");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(DefaultGrafanaEndpointProvider.endpointRule_6(), DefaultGrafanaEndpointProvider.endpointRule_35()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultGrafanaEndpointProvider.endpointRule_0()).addRule(DefaultGrafanaEndpointProvider.endpointRule_5()).build();
    }
}

