/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaRequest;
import software.amazon.awssdk.services.grafana.model.UserType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPermissionsRequest
extends GrafanaRequest
implements ToCopyableBuilder<Builder, ListPermissionsRequest> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(ListPermissionsRequest.getter(ListPermissionsRequest::groupId)).setter(ListPermissionsRequest.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("groupId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListPermissionsRequest.getter(ListPermissionsRequest::maxResults)).setter(ListPermissionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPermissionsRequest.getter(ListPermissionsRequest::nextToken)).setter(ListPermissionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(ListPermissionsRequest.getter(ListPermissionsRequest::userId)).setter(ListPermissionsRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userId").build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userType").getter(ListPermissionsRequest.getter(ListPermissionsRequest::userTypeAsString)).setter(ListPermissionsRequest.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userType").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(ListPermissionsRequest.getter(ListPermissionsRequest::workspaceId)).setter(ListPermissionsRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, USER_ID_FIELD, USER_TYPE_FIELD, WORKSPACE_ID_FIELD));
    private final String groupId;
    private final Integer maxResults;
    private final String nextToken;
    private final String userId;
    private final String userType;
    private final String workspaceId;

    private ListPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.userId = builder.userId;
        this.userType = builder.userType;
        this.workspaceId = builder.workspaceId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String userId() {
        return this.userId;
    }

    public final UserType userType() {
        return UserType.fromValue(this.userType);
    }

    public final String userTypeAsString() {
        return this.userType;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionsRequest)) {
            return false;
        }
        ListPermissionsRequest other = (ListPermissionsRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userTypeAsString(), other.userTypeAsString()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"ListPermissionsRequest").add("GroupId", (Object)this.groupId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("UserId", (Object)this.userId()).add("UserType", (Object)this.userTypeAsString()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionsRequest, T> g) {
        return obj -> g.apply((ListPermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaRequest.BuilderImpl
    implements Builder {
        private String groupId;
        private Integer maxResults;
        private String nextToken;
        private String userId;
        private String userType;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionsRequest model) {
            super(model);
            this.groupId(model.groupId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.userId(model.userId);
            this.userType(model.userType);
            this.workspaceId(model.workspaceId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserType() {
            return this.userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPermissionsRequest build() {
            return new ListPermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPermissionsRequest> {
        public Builder groupId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder userId(String var1);

        public Builder userType(String var1);

        public Builder userType(UserType var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

