/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes;
import software.amazon.awssdk.services.grafana.model.AuthenticationProvidersCopier;
import software.amazon.awssdk.services.grafana.model.AwsSsoAuthentication;
import software.amazon.awssdk.services.grafana.model.SamlAuthentication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationDescription> {
    private static final SdkField<AwsSsoAuthentication> AWS_SSO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsSso").getter(AuthenticationDescription.getter(AuthenticationDescription::awsSso)).setter(AuthenticationDescription.setter(Builder::awsSso)).constructor(AwsSsoAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSso").build()}).build();
    private static final SdkField<List<String>> PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("providers").getter(AuthenticationDescription.getter(AuthenticationDescription::providersAsStrings)).setter(AuthenticationDescription.setter(Builder::providersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SamlAuthentication> SAML_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("saml").getter(AuthenticationDescription.getter(AuthenticationDescription::saml)).setter(AuthenticationDescription.setter(Builder::saml)).constructor(SamlAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("saml").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SSO_FIELD, PROVIDERS_FIELD, SAML_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsSsoAuthentication awsSso;
    private final List<String> providers;
    private final SamlAuthentication saml;

    private AuthenticationDescription(BuilderImpl builder) {
        this.awsSso = builder.awsSso;
        this.providers = builder.providers;
        this.saml = builder.saml;
    }

    public final AwsSsoAuthentication awsSso() {
        return this.awsSso;
    }

    public final List<AuthenticationProviderTypes> providers() {
        return AuthenticationProvidersCopier.copyStringToEnum(this.providers);
    }

    public final boolean hasProviders() {
        return this.providers != null && !(this.providers instanceof SdkAutoConstructList);
    }

    public final List<String> providersAsStrings() {
        return this.providers;
    }

    public final SamlAuthentication saml() {
        return this.saml;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSso());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviders() ? this.providersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.saml());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationDescription)) {
            return false;
        }
        AuthenticationDescription other = (AuthenticationDescription)obj;
        return Objects.equals(this.awsSso(), other.awsSso()) && this.hasProviders() == other.hasProviders() && Objects.equals(this.providersAsStrings(), other.providersAsStrings()) && Objects.equals(this.saml(), other.saml());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationDescription").add("AwsSso", (Object)this.awsSso()).add("Providers", this.hasProviders() ? this.providersAsStrings() : null).add("Saml", (Object)this.saml()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsSso": {
                return Optional.ofNullable(clazz.cast(this.awsSso()));
            }
            case "providers": {
                return Optional.ofNullable(clazz.cast(this.providersAsStrings()));
            }
            case "saml": {
                return Optional.ofNullable(clazz.cast(this.saml()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationDescription, T> g) {
        return obj -> g.apply((AuthenticationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsSsoAuthentication awsSso;
        private List<String> providers = DefaultSdkAutoConstructList.getInstance();
        private SamlAuthentication saml;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationDescription model) {
            this.awsSso(model.awsSso);
            this.providersWithStrings(model.providers);
            this.saml(model.saml);
        }

        public final AwsSsoAuthentication.Builder getAwsSso() {
            return this.awsSso != null ? this.awsSso.toBuilder() : null;
        }

        public final void setAwsSso(AwsSsoAuthentication.BuilderImpl awsSso) {
            this.awsSso = awsSso != null ? awsSso.build() : null;
        }

        @Override
        @Transient
        public final Builder awsSso(AwsSsoAuthentication awsSso) {
            this.awsSso = awsSso;
            return this;
        }

        public final Collection<String> getProviders() {
            if (this.providers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.providers;
        }

        public final void setProviders(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
        }

        @Override
        @Transient
        public final Builder providersWithStrings(Collection<String> providers) {
            this.providers = AuthenticationProvidersCopier.copy(providers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder providersWithStrings(String ... providers) {
            this.providersWithStrings(Arrays.asList(providers));
            return this;
        }

        @Override
        @Transient
        public final Builder providers(Collection<AuthenticationProviderTypes> providers) {
            this.providers = AuthenticationProvidersCopier.copyEnumToString(providers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder providers(AuthenticationProviderTypes ... providers) {
            this.providers(Arrays.asList(providers));
            return this;
        }

        public final SamlAuthentication.Builder getSaml() {
            return this.saml != null ? this.saml.toBuilder() : null;
        }

        public final void setSaml(SamlAuthentication.BuilderImpl saml) {
            this.saml = saml != null ? saml.build() : null;
        }

        @Override
        @Transient
        public final Builder saml(SamlAuthentication saml) {
            this.saml = saml;
            return this;
        }

        public AuthenticationDescription build() {
            return new AuthenticationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationDescription> {
        public Builder awsSso(AwsSsoAuthentication var1);

        default public Builder awsSso(Consumer<AwsSsoAuthentication.Builder> awsSso) {
            return this.awsSso((AwsSsoAuthentication)((AwsSsoAuthentication.Builder)AwsSsoAuthentication.builder().applyMutation(awsSso)).build());
        }

        public Builder providersWithStrings(Collection<String> var1);

        public Builder providersWithStrings(String ... var1);

        public Builder providers(Collection<AuthenticationProviderTypes> var1);

        public Builder providers(AuthenticationProviderTypes ... var1);

        public Builder saml(SamlAuthentication var1);

        default public Builder saml(Consumer<SamlAuthentication.Builder> saml) {
            return this.saml((SamlAuthentication)((SamlAuthentication.Builder)SamlAuthentication.builder().applyMutation(saml)).build());
        }
    }
}

