/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetWorkflowRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetWorkflowRunRequest.getter(GetWorkflowRunRequest::name)).setter(GetWorkflowRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetWorkflowRunRequest.getter(GetWorkflowRunRequest::runId)).setter(GetWorkflowRunRequest.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetWorkflowRunRequest.getter(GetWorkflowRunRequest::includeGraph)).setter(GetWorkflowRunRequest.setter(Builder::includeGraph)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGraph").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RUN_ID_FIELD, INCLUDE_GRAPH_FIELD));
    private final String name;
    private final String runId;
    private final Boolean includeGraph;

    private GetWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.runId = builder.runId;
        this.includeGraph = builder.includeGraph;
    }

    public String name() {
        return this.name;
    }

    public String runId() {
        return this.runId;
    }

    public Boolean includeGraph() {
        return this.includeGraph;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGraph());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunRequest)) {
            return false;
        }
        GetWorkflowRunRequest other = (GetWorkflowRunRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.includeGraph(), other.includeGraph());
    }

    public String toString() {
        return ToString.builder((String)"GetWorkflowRunRequest").add("Name", (Object)this.name()).add("RunId", (Object)this.runId()).add("IncludeGraph", (Object)this.includeGraph()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "IncludeGraph": {
                return Optional.ofNullable(clazz.cast(this.includeGraph()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunRequest, T> g) {
        return obj -> g.apply((GetWorkflowRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String runId;
        private Boolean includeGraph;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunRequest model) {
            super(model);
            this.name(model.name);
            this.runId(model.runId);
            this.includeGraph(model.includeGraph);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRunId() {
            return this.runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final Boolean getIncludeGraph() {
            return this.includeGraph;
        }

        @Override
        public final Builder includeGraph(Boolean includeGraph) {
            this.includeGraph = includeGraph;
            return this;
        }

        public final void setIncludeGraph(Boolean includeGraph) {
            this.includeGraph = includeGraph;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkflowRunRequest build() {
            return new GetWorkflowRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowRunRequest> {
        public Builder name(String var1);

        public Builder runId(String var1);

        public Builder includeGraph(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

