/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListSchemasRequest;
import software.amazon.awssdk.services.glue.model.ListSchemasResponse;
import software.amazon.awssdk.services.glue.model.SchemaListItem;

public class ListSchemasPublisher
implements SdkPublisher<ListSchemasResponse> {
    private final GlueAsyncClient client;
    private final ListSchemasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSchemasPublisher(GlueAsyncClient client, ListSchemasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSchemasPublisher(GlueAsyncClient client, ListSchemasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSchemasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSchemasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SchemaListItem> schemas() {
        return this.flatMapIterable(response -> response.schemas());
    }

    private class ListSchemasResponseFetcher
    implements AsyncPageFetcher<ListSchemasResponse> {
        private ListSchemasResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSchemasResponse> nextPage(ListSchemasResponse previousPage) {
            if (previousPage == null) {
                return ListSchemasPublisher.this.client.listSchemas(ListSchemasPublisher.this.firstRequest);
            }
            return ListSchemasPublisher.this.client.listSchemas((ListSchemasRequest)((Object)ListSchemasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

