/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListMaterializedViewRefreshTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.ListMaterializedViewRefreshTaskRunsResponse;
import software.amazon.awssdk.services.glue.model.MaterializedViewRefreshTaskRun;

public class ListMaterializedViewRefreshTaskRunsIterable
implements SdkIterable<ListMaterializedViewRefreshTaskRunsResponse> {
    private final GlueClient client;
    private final ListMaterializedViewRefreshTaskRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMaterializedViewRefreshTaskRunsIterable(GlueClient client, ListMaterializedViewRefreshTaskRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMaterializedViewRefreshTaskRunsResponseFetcher();
    }

    public Iterator<ListMaterializedViewRefreshTaskRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MaterializedViewRefreshTaskRun> materializedViewRefreshTaskRuns() {
        Function<ListMaterializedViewRefreshTaskRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.materializedViewRefreshTaskRuns() != null) {
                return response.materializedViewRefreshTaskRuns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMaterializedViewRefreshTaskRunsResponseFetcher
    implements SyncPageFetcher<ListMaterializedViewRefreshTaskRunsResponse> {
        private ListMaterializedViewRefreshTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListMaterializedViewRefreshTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMaterializedViewRefreshTaskRunsResponse nextPage(ListMaterializedViewRefreshTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return ListMaterializedViewRefreshTaskRunsIterable.this.client.listMaterializedViewRefreshTaskRuns(ListMaterializedViewRefreshTaskRunsIterable.this.firstRequest);
            }
            return ListMaterializedViewRefreshTaskRunsIterable.this.client.listMaterializedViewRefreshTaskRuns((ListMaterializedViewRefreshTaskRunsRequest)((Object)ListMaterializedViewRefreshTaskRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

